#region AuthorHeader
//
//	EvoSystem version 2.1, by Xanthos
//
//
#endregion AuthorHeader
using System;
using Server;
using Server.Items;
using Server.Mobiles;

namespace Xanthos.Evo
{
    public abstract class BaseEvoDust : Item
    {
        public override double DefaultWeight
        {
            get { return 0.01; }
        }

        public BaseEvoDust() : this(1)
        {
        }

        public BaseEvoDust(int amount) : base(0x26B8)
        {
            Stackable = true;
            Weight = 0.01;
            Amount = amount;
            Name = "Evolution Dust";
            Hue = 1153;
        }

        public BaseEvoDust(Serial serial) : base(serial)
        {
        }

        // Define as concrete in subclasses and return an instance of your BaseEvoDust subclass there
        public abstract BaseEvoDust NewDust();

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }
    }

    public class RandomDustBag : Bag
    {
        [Constructable]
        public RandomDustBag() : this(1000)
        {
        }

        [Constructable]
        public RandomDustBag(int amount)
        {
            Name = String.Format("nahodny evolution dust {0}ks", amount);
            Hue = 986;

            switch (Utility.Random(4))
            {
                case 0: DropItem(new RaelisDragonDust(amount)); break;
                case 1: DropItem(new RaelisDemonioDust(amount)); break;
                case 2: DropItem(new HiryuEvoDust(amount)); break;
                case 3: DropItem(new EvoSpiderDust(amount)); break;
            }
        }

        public RandomDustBag(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version 
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}